#ifndef TABLEPROPERTY_H
#define TABLEPROPERTY_H

#include <QtCore>
#include <QObject>

class QString;
class filedProperty;

class tableProperty
{
	public:
		tableProperty();
		virtual ~tableProperty();
	public:
		void setTableName(const QString &name);
		void setfieldInfo(int inx,bool Key,const QString &name,const QString &dataType,const QString &fieldLength,int null,const QString &defaultType,const QString &comment);
		void setIndex(int inx);
		QString getTableName() const;
		bool getFieldkey(int inx);
		QString getFieldname(int inx);
		QString getFieldDataType(int inx);
		QString getFieldLength(int inx);
		int getFieldNull(int inx);
		QString getFieldDefault(int inx);
		QString getComment(int inx);
		
		// 
		QList <filedProperty *> fieldInfo;
	private:
		int index;
		QString	tableName;
	
};

class filedProperty
{
	public:
		filedProperty();
		//
		filedProperty(bool Key,const QString &name,const QString &dataType,const QString &fieldLength,int null,const QString &defaultType,const QString &cmt);
	public:
		void setPrimaryKey(bool Key);
		void setFieldName(const QString &name);
		void setFieldDataType(const QString &dataType);
		void setNotNull(int null);
		void setDefaultVaule(const QString &defaultType);
		void setComment(const QString &comment);
		void setAllData(bool Key,const QString &name,const QString &dataType,const QString &fieldLength,int null,const QString &defaultType,const QString &cmt);
		bool getPrimaryKey();
		QString getFieldName() const;
		QString getFieldDataType() const;
		int getNotNull();
		QString getDefaultVaule() const;
		QString getComment() const;
		QString	getFieldLength() const;		//field Length
		
	private:
		bool		primaryKey;			//PrimaryKey
		QString	fieldName;			//field̸
		QString	fieldDataType;		//field DataType
		QString	fieldLength;		//field Length
		int		notNull;			//Not Null
		QString	defaultVaule;		//default
		QString	comment;			//
};

inline QString	filedProperty::getFieldLength() const
{
	return this->fieldLength;
}
#endif
